﻿<%@ Page Language="C#" AutoEventWireup="true" EnableSessionState="True" Theme="Voxco"
	Trace="false" Async="true" Title="<%$ Resources:Resource, VoxcoReporting%>" Inherits="Report_ReportQuestionStatistic" Codebehind="ReportQuestionStatistic.aspx.cs" %>

<%@ Register Src="../Common/ToggleHeader.ascx" TagName="ToggleHeader" TagPrefix="uc1" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">


<html xmlns="http://www.w3.org/1999/xhtml" >
	<head id="Head1" runat="server">
		<title>Voxco Reporting</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<style type="text/css">@import url( css/voxco_mng.css ); </style>
		<link rel="stylesheet" type="text/css" href="../css/ReportingStyleSheet.css" />
	</head>
	
	<body runat="server">
		
		<form id="form1" method="post" runat="server">
		
		<telerik:RadScriptBlock ID="ScriptManager" runat="server">
			<script language="javascript" type="text/javascript">
				function RefreshResultCodesSelection()
				{
					window.parent.OnResfreshSelectedCode();
				}

				function DeleteClick()
				{
					return confirm('<%= TranslateForJS("QuestionStatisticDeleteSelected") %>');
				}

				function UpdateClick()
				{
					return confirm('<%= TranslateForJS("QuestionStatisticUpdateSelected") %>');
				}
			</script>
		</telerik:RadScriptBlock>
		
		<!-- OBJECY DATA SOURCE -->
		<asp:ObjectDataSource	ID="VariablesDataSource" runat="server" SelectMethod="GetVariables" TypeName="Voxco.Reporting.DataSource.QuestionStatistics">
		</asp:ObjectDataSource>
			
		<asp:ObjectDataSource	ID="QuestionStatisticCreationOperationsDataSource" runat="server" SelectMethod="GetCreationOperations" TypeName="Voxco.Reporting.DataSource.QuestionStatistics">
		</asp:ObjectDataSource>
								
		<asp:ObjectDataSource	ID="QuestionStatisticEditionOperationsDataSource" runat="server" SelectMethod="GetEditionOperations" TypeName="Voxco.Reporting.DataSource.QuestionStatistics">
		</asp:ObjectDataSource>

		<asp:ObjectDataSource	ID="QuestionStatisticOptionsDataSource" runat="server" SelectMethod="GetOptions" TypeName="Voxco.Reporting.DataSource.QuestionStatistics">
		</asp:ObjectDataSource>

		<asp:ObjectDataSource	ID="QuestionStatistics" runat="server" SelectMethod="Get" UpdateMethod="Update" DeleteMethod="Delete" InsertMethod="Insert"
				TypeName="Voxco.Reporting.DataSource.QuestionStatistics"
				OnDeleted="QuestionStatistics_Deleted" 
				OnInserted="QuestionStatistics_Inserted" 
				OnUpdated="QuestionStatistics_Updated" >
				<InsertParameters>
					<asp:Parameter Name="Name" Type="String" />
					<asp:Parameter Name="Operation" Type="String" />
					<asp:Parameter Name="Option" Type="String" />
					<asp:Parameter Name="NbOfDecimals" Type="String" />
					<asp:Parameter Name="Variable" Type="String" />
					<asp:Parameter Name="HighDelimiter" Type="String" />
					<asp:Parameter Name="LowDelimiter" Type="String" />
					<asp:Parameter Name="Id" Type="Int32" />
					<asp:Parameter Name="CanBeDeleted" Type="String" />
				</InsertParameters>
				<UpdateParameters>
					<asp:Parameter Name="Id" Type="Int32" />
					<asp:Parameter Name="Name" Type="String" />
					<asp:Parameter Name="Operation" Type="String" />
					<asp:Parameter Name="Option" Type="String" />
					<asp:Parameter Name="NbOfDecimals" Type="String" />
					<asp:Parameter Name="Variable" Type="String" />
					<asp:Parameter Name="HighDelimiter" Type="String" />
					<asp:Parameter Name="LowDelimiter" Type="String" />
					<asp:Parameter Name="CanBeDeleted" Type="String" />
				</UpdateParameters>
				<DeleteParameters>
					<asp:Parameter Name="Id" Type="Int32" />
					<asp:Parameter Name="CanBeDeleted" Type="String" />
				</DeleteParameters>
		</asp:ObjectDataSource>
		<!-- END OBJECY DATA SOURCE -->							
		
		<telerik:RadScriptManager ID="RadScriptManager1" runat="server"></telerik:RadScriptManager>
		<br />
			<table style="width: 100%;">
				<tr>
					<td>
						<telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" OnAjaxRequest="AjaxPanel_AjaxRequest" Height="400px" >

							
							<telerik:RadGrid ID="grdQuestionStatistic" runat="server" AllowSorting="True"
								 SortingSettings-SortToolTip="<%$ Resources:Resource, SortingHeader %>"
								 AllowAutomaticInserts="True" AllowAutomaticUpdates="True" AllowAutomaticDeletes="true"
								 SortingSettings-SortedAscToolTip="<%$ Resources:Resource, SortingHeader %>" 
								 SortingSettings-SortedDescToolTip="<%$ Resources:Resource, SortingHeader %>" 
								 OnItemCreated="grdQuestionStatistic_ItemCreated"								 
								 GridLines="None" AllowMultiRowSelection="True" AllowMultiRowEdit="false"
								 DataSourceID="QuestionStatistics" OnItemCommand="QuestionStatisticGrid_ItemCommand"
								 EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
								 <MasterTableView ClientDataKeyNames="Id"></MasterTableView>
								<ClientSettings>								
									<Selecting AllowRowSelect="True" />
									<Scrolling AllowScroll="True" UseStaticHeaders="True" />
								</ClientSettings>

								<MasterTableView CommandItemDisplay="Top" AutoGenerateColumns="False" DataSourceID="QuestionStatistics"
											EditMode="InPlace" DataKeyNames="Id,CanBeDeleted" Width="100%">
									<CommandItemTemplate>
										<div style="padding: 0 5px;">
											<asp:LinkButton ID="btnEditSelected" runat="server" CommandName="EditSelected" 
															Visible='<%# grdQuestionStatistic.EditIndexes.Count == 0 && !grdQuestionStatistic.MasterTableView.IsItemInserted %>'>
															<img style="border:0px;vertical-align:middle;" alt="" src="../icons/Edit.gif" />
															<asp:Literal ID="lblEdit" runat="server" Text="<%$ Resources:Resource,Edit %>" />
															</asp:LinkButton>&nbsp;&nbsp;
															
											<asp:LinkButton ID="btnUpdateEdited" runat="server" CommandName="UpdateEdited" OnClientClick="return UpdateClick(this);"
															Visible='<%# grdQuestionStatistic.EditIndexes.Count > 0 %>'>
															<img style="border:0px;vertical-align:middle;" alt="" src="../icons/Update.gif" />
															<asp:Literal ID="lblUpdate" runat="server" Text="<%$ Resources:Resource,Accept %>" />
															</asp:LinkButton>&nbsp;&nbsp;
															
											<asp:LinkButton ID="btnCancel" runat="server" CommandName="CancelAll" 
															Visible='<%# grdQuestionStatistic.EditIndexes.Count > 0 || grdQuestionStatistic.MasterTableView.IsItemInserted %>'>
															<img style="border:0px;vertical-align:middle;" alt="" src="../icons/Cancel.gif" />
															<asp:Literal ID="lblCancel" runat="server" Text="<%$ Resources:Resource,Cancel %>" />
															</asp:LinkButton>&nbsp;&nbsp;
															
											<asp:LinkButton ID="btnAdd" runat="server" CommandName="InitInsert" 
															Visible='<%# !grdQuestionStatistic.MasterTableView.IsItemInserted && grdQuestionStatistic.EditIndexes.Count == 0 %>'>
															<img style="border:0px;vertical-align:middle;" alt="" src="../icons/document_add.png" />
															<asp:Literal ID="lblAdd" runat="server" Text="<%$ Resources:Resource,Add %>" />
															</asp:LinkButton>&nbsp;&nbsp;
															
											<asp:LinkButton ID="btnInsert" runat="server" CommandName="PerformInsert" 
															Visible='<%# grdQuestionStatistic.MasterTableView.IsItemInserted %>'>
															<img style="border:0px;vertical-align:middle;" alt="" src="../icons/Update.gif" />
															<asp:Literal ID="lblInsert" runat="server" Text="<%$ Resources:Resource,Accept %>" />
															</asp:LinkButton>&nbsp;&nbsp;
															
											<asp:LinkButton ID="btnDelete" OnClientClick="return DeleteClick();"
															runat="server" CommandName="DeleteSelected" Visible='<%# !grdQuestionStatistic.MasterTableView.IsItemInserted %>'>
															<img style="border:0px;vertical-align:middle;" alt="" src="../icons/Selection_delete.png" />
															<asp:Literal ID="lblDelete" runat="server" Text="<%$ Resources:Resource,Delete %>" />
															</asp:LinkButton>&nbsp;&nbsp;
										</div>
									</CommandItemTemplate>
									<Columns>
										<telerik:GridClientSelectColumn UniqueName="Selected" >
											<HeaderStyle Width="30px" HorizontalAlign="Left" />
											<ItemStyle Width="30px" HorizontalAlign="Left" />
										</telerik:GridClientSelectColumn>
										
										<telerik:GridBoundColumn DataField="Id" Display="False" UniqueName="Id">
										</telerik:GridBoundColumn>
										
										<telerik:GridBoundColumn DataField="Name" HeaderText="<%$ Resources:Resource, QuestionStatisticName %>" UniqueName="StatisticName">
											<HeaderStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
											<ItemStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
										</telerik:GridBoundColumn>
										<telerik:GridDropDownColumn UniqueName="Variable" HeaderText="<%$ Resources:Resource,Variable %>" DataField="Variable" 
										DataSourceID = "VariablesDataSource" ListValueField="Value" ListTextField="Text">
											<HeaderStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
											<ItemStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
										</telerik:GridDropDownColumn>

										<telerik:GridDropDownColumn UniqueName="Operation" HeaderText="<%$ Resources:Resource,QuestionStatisticOperation %>" DataField="Operation" ListValueField="Value" 
										ListTextField="Text" DataSourceID="QuestionStatisticCreationOperationsDataSource">
											<HeaderStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
											<ItemStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
										</telerik:GridDropDownColumn>
										
										<telerik:GridDropDownColumn UniqueName="Option" HeaderText="<%$ Resources:Resource,Options %>" DataField="Option" 
										ListValueField="Value" ListTextField="Text" DataSourceID = "QuestionStatisticOptionsDataSource">
											<HeaderStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
											<ItemStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
										</telerik:GridDropDownColumn>
										
										<telerik:GridBoundColumn UniqueName="NbOfDecimals" HeaderText="<%$ Resources:Resource,Decimals %>" DataField="NbOfDecimals">
											<HeaderStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
											<ItemStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
										</telerik:GridBoundColumn>
										
										<telerik:GridBoundColumn DataField="LowDelimiter" HeaderText="<%$ Resources:Resource,LowDelimiter %>" UniqueName="LowDelimiter">
											<HeaderStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
											<ItemStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
										</telerik:GridBoundColumn>
										
										<telerik:GridBoundColumn DataField="HighDelimiter" HeaderText="<%$ Resources:Resource,HighDelimiter %>" UniqueName="HighDelimiter">
											<HeaderStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
											<ItemStyle Width="15%" Wrap="false" HorizontalAlign="Left" />
										</telerik:GridBoundColumn>
										
										<%--<radG:GridTemplateColumn	UniqueName="NbOfDecimals" HeaderText="<%$ Resources:Resource,Decimals %>" HeaderStyle-Width="75px"
																	DataField="NbOfDecimals">
																	<EditItemTemplate>
																		<radI:RadNumericTextBox Text='<%# Eval("NbOfDecimals") %>' runat="server" AutoPostBack="false" ID="numericNbDecimalEditor" MaxLength="5" Width="30px" Height="18px" />
																	</EditItemTemplate>
																	<ItemTemplate>
																		<radI:RadNumericTextBox Text='<%# Eval("NbOfDecimals") %>' runat="server" AutoPostBack="false" ID="numericNbDecimal" MaxLength="5" Width="30px" Height="18px" Enabled="false" />
																	</ItemTemplate>
										</radG:GridTemplateColumn>
										
										<radG:GridTemplateColumn	DataField="LowDelimiter" HeaderText="<%$ Resources:Resource,LowDelimiter %>"  HeaderStyle-Width="50px"
																	UniqueName="LowDelimiter">
																	<EditItemTemplate>
																		<radI:RadNumericTextBox Text='<%# Eval("LowDelimiter") %>' runat="server" AutoPostBack="false" ID="numericLowDelimiterEditor" MaxLength="5" Width="30px" Height="18px" />
																	</EditItemTemplate>
																	<ItemTemplate>
																		<radI:RadNumericTextBox Text='<%# Eval("LowDelimiter") %>' runat="server" AutoPostBack="false" ID="numericLowDelimiter" MaxLength="5" Width="30px" Height="18px" Enabled="false" />
																	</ItemTemplate>
										</radG:GridTemplateColumn>

										<radG:GridTemplateColumn	DataField="HighDelimiter" HeaderText="<%$ Resources:Resource,HighDelimiter %>" HeaderStyle-Width="50px"
																	UniqueName="HighDelimiter">
																	<EditItemTemplate>
																		<radI:RadNumericTextBox Text='<%# Eval("HighDelimiter") %>' runat="server" AutoPostBack="false" ID="numericHighDelimiterEditor" MaxLength="5" Width="30px" Height="18px" />
																	</EditItemTemplate>
																	<ItemTemplate>
																		<asp:Label runat="server" ID = "numericHighDelimiter" Text='<%# Eval("HighDelimiter") %>' />
																		<radI:RadNumericTextBox Text='<%# Eval("HighDelimiter") %>' runat="server" AutoPostBack="false" ID="numericHighDelimiter" MaxLength="5" Width="30px" Height="18px" Enabled="false" />
																	</ItemTemplate>
										</radG:GridTemplateColumn>--%>
										
										<telerik:GridBoundColumn DataField="CanBeDeleted" Display="False" UniqueName="CanBeDeleted"></telerik:GridBoundColumn>
										
										
									</Columns>									
								</MasterTableView>
							</telerik:RadGrid>
						</telerik:RadAjaxPanel>						
					</td>
					<td  valign="middle" style="text-align: center; width: 25px;">
						<asp:ImageButton ID="btnAddStatistic" runat="server" ImageUrl="~/icons/arrow_right_blue.png" OnClick="btnAddQuestionStatistic_Click" ToolTip="<%$ Resources:Resource, AddSelectedItems %>" />
						<br />
						<br />
						<asp:ImageButton ID="btnAddResultCodeToNewGroup" runat="server" ImageUrl="~/icons/arrow_right_green.png" OnClick="btnAddQuestionStatisticToNewGroup_Click" ToolTip="<%$ Resources:Resource, AddSelectedItemsToNewGroup %>" />
					</td>
				</tr>
			</table>
		</form>
	</body>
</html>
